//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property description "DEMO Indicator"
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_applied_price   PRICE_CLOSE
#property indicator_buffers         1
#property indicator_plots           1
#property indicator_type1           DRAW_LINE
#property indicator_color1          clrRed
#property indicator_style1          STYLE_SOLID
#property indicator_width1          1
#property indicator_label1          "EMA"
//+------------------------------------------------------------------+
input uint              def_nPeriods   = 9;           //Period:
input ENUM_MA_METHOD    def_MA_Method  = MODE_EMA;    //Method:
//+------------------------------------------------------------------+
double   Buff_iMA[];
int      Handle;
//+------------------------------------------------------------------+
int OnInit(void)
{
   SetIndexBuffer(0, Buff_iMA, INDICATOR_DATA);
   if ((Handle = iMA(NULL, 0, def_nPeriods, 0, def_MA_Method, _AppliedTo)) == INVALID_HANDLE)
   {
      Print("Could not start the indicator...");
      return INIT_FAILED;
   };

   return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
  	ArrayInitialize(Buff_iMA, EMPTY_VALUE);
   CopyBuffer(Handle, 0, 0, def_nPeriods, Buff_iMA);

   return rates_total;
};
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   if (Handle != INVALID_HANDLE) 
      IndicatorRelease(Handle);
};
//+------------------------------------------------------------------+